module List = 

  (* left "folding" *)
  let rec fold f accu l = (* TODO: replace by "let rec fold f accu = λ. 
                                                  [] → accu 
                                                | t :: q → fold f (f accu t) q" *)
    match l with 
        [] -> accu
      | t :: q -> fold f (f accu t) q
    end
    
  let rec iter f l = 
    match l with 
        [] -> ()
      | t :: q -> f t; iter f q
    end
     
  let rec map f l = (* TODO: add function keyword *)
    match l with 
        [] -> []
      | t :: q -> f t :: map f q
    end
     
  let rec filter f l = 
    match l with 
        [] -> []
      | t :: q -> let r = filter f q in 
                  if f t then t :: r else r
    end
    
    
  let length l = fold (fun b _ -> b + 1) 0 l (* TODO: curried version? *)
  let rev l = fold (fun b a -> a :: b) [] l
  let map_rev f l = fold (fun b a -> f a :: b) [] l
  let filter_rev f l = fold (fun b a -> if f a then a :: b else b) [] l
  let mem a l = fold (fun b e -> b || a = e) false l
  let forallof f l = fold (fun b e -> b && f e) false l
  let exists f l = fold (fun b e -> b || f e) false l
  let mem_assoc a l = fold (fun b (e, _) -> b || a = e) false l
  let assoc a l = fold (fun b (e, v) -> if e = a then Some v else b) None l
      (*case l  TODO: replace
      | [] -> None
      | (k, v) :: q -> if k = a then Some v else assoc a q
    end*)
  let remove_assoc a l = filter (fun (k, v) -> k <> a) l
  let append_rev l1 l2 = fold (fun b a -> a :: b) l2 l1
  let append l1 l2 = rev (fold (fun b a -> a :: b) (rev l1) l2)
  
  let rec nth n l = 
    case n 
     | 0 -> case l
             | t :: _ -> t
             | [] -> error 1 (* cannot happen with rich types *)
            end
     | n -> case l 
             | _ :: q -> nth (n - 1) q
             | [] -> error 1 (* cannot happen with rich types *)
            end
    end
  
  let iteri f l = let _ = fold (fun i a -> let () = ((f i a); ()) in i + 1) 0 l in () (* TODO: "f i a; i + 1" does not type *)
  let mapi f l = rev (fst (fold (fun (b, i) a -> (f i a :: b, i + 1)) ([], 0) l))
  
  
  
  (* TODO: rename and implement slice *)
  let split l i = 
    let rec split_aux l n j accu = 
      if j >= n then 
        (accu, l)
      else 
        match l with 
            [] -> (accu, [])
          | t :: q -> split_aux q n (j + 1) (t :: accu)
        end in 
    let (l1, l2) = split_aux l i 0 [] in 
    (rev l1, l2)
    
  
  let to_array l = 
    let arr = Array.build (length l) in 
    let _ = fold (fun i e -> let () = arr[i] <- e in i + 1) 0 l in 
    arr

  let from_array arr = 
    Array.fold (fun b a -> a :: b) [] arr

endmodule

let (@) = List.append
